﻿/*********************************************************************
Copyright 2003 © Victor Company of Japan, Limited All Right Reserved.
The following JavaScript for the XML Service Manual includes our
patent-pending algorithm.
**********************************************************************/

/*************
**  バージョン情報表示
*************/
//parts_js = '1.1.0';		// 2003.05.22 - I.NUNO
//parts_js = '1.2.0';		// 2003.06.03 - I.NUNO
//parts_js = '1.3.0';		// 2003.06.09 - I.NUNO
//parts_js = '1.4.0';		// 2003.06.27 - I.NUNO
//parts_js = '1.5.0';		// 2003.07.01 - I.NUNO
parts_js = '1.6.0';			// 2003.12.23 - I.NUNO

/*************
**  部品表選択表示関連変数
**************/
var elm = null;
var clrbackground = null;
var clr = null;
var selected = '';

/*************
**  データレコードセット関連変数
**************/
var safety = null;
var symbol = null;
var orflg = null;
var parts_no = null;
var parts_name = null;
var description = null;
var area = null;
var qty = null;
var datasheet_link = null;
var blockno = null;

/*************
**  部品検索関連変数
**************/
var foundlist = null;
var findType = '';
var findText = '';
var event_count = 0;

/*************
**  データシート関連変数
**************/
var dataSheet = null;

/*************
**  お気に入り関連変数
**************/
var favoriteWin = null;

/*************
**  サービスマニュアル基本情報変数
**************/
var CurModels = '';
var CurModel = '';
var CurTargetModel = '';
var CurManualNo = '';
var CurManualIssuey = '';

/*************
**  マイノート関連変数
**************/
var mynote = null;
var mynotelist = null;
var note_blockno = '';
var note_refno = '';
var note_savefile = '';
//var note_drawid = '';
var viewmode = '';

// マイノート用XML
var xmlmynote = new ActiveXObject("Microsoft.XMLDOM");
xmlmynote.async = false;

// マイノート用XSLT
var xslmynote = new ActiveXObject('Microsoft.XMLDOM');
xslmynote.async = false;
xslmynote.load("mynote.xsl");

// マイノートリスト用XSLT
var xslmynotelist = new ActiveXObject('Microsoft.XMLDOM');
xslmynotelist.async = false;
xslmynotelist.load("mynotelist.xsl");

/*************
**  マイドロー関連変数
**************/
var draw_savefile = '';
// マイノート用XML
var xmlmydraw = new ActiveXObject("Microsoft.XMLDOM");
xmlmydraw.async = false;

/*************
**  SVGデータロード確認用変数
**************/
var svg0_loaded = false;
var svg1_loaded = false;

/*************
**  ブロック図ロード確認用変数
**************/
var blockdiagram_loaded = false;

/*************
**  部品表XML取得（初期設定）
**************/
var xmlparts = new ActiveXObject("Microsoft.XMLDOM");
xmlparts.async = false;
xmlparts.load("../" + part_FileName);		// part_FileNameは、js/parts.js にて設定

// 差分部品表用XML
var xmlparts_diff = new ActiveXObject('Microsoft.XMLDOM');
xmlparts_diff.async = false;

/*************
**  部品オーダーXML設定（初期設定）
**************/
var order = null;
var ordercnt = 0;
var orderModelIndex = 0;
var basket = null;
var xmlorder = new ActiveXObject("Microsoft.XMLDOM");
xmlorder.async = false;
xmlorder.loadXML('<?xml version="1.0"?><PARTSORDER/>');

// オーダータイプ
var orderType = "normal";
// J-POST
var JpostEnabled = "";
var JpostMail = "";
var JpostAC = "";
var JpostUS = "";
var JpostPS = "";
var JpostSP = "";
var JpostPO = "";
var JpostSM = 0;
var JpostME = "";
var JpostUR = 0;
var JpostFolder = "";
// JASPER
var JasperEnabled = "";
var JasperMail = "";
var JasperUS = "";
var JasperPS = "";
var JasperPO = "";

/*************
**  TOC_XML取得（初期設定）
**************/
xml_doc = new ActiveXObject("Microsoft.XMLDOM");
xml_doc.async = false;
xml_doc.load("../toc.xml");

CurModels = xml_doc.documentElement.getElementsByTagName("MNAME").item(0).text;
CurModel = CurModels.split(",");
CurTargetModel = CurModel[0];

CurManualNo = xml_doc.documentElement.getElementsByTagName("MNO").item(0).text;
CurManualIssuey = xml_doc.documentElement.getElementsByTagName("ISSUEY").item(0).text;

/*************
**  部品選択時コンテキストメニュー設定（SVGコンテキストメニューから）
**************/
function showPartsContextMemu(target, cir_name, pwb_name) {
	target = target.toUpperCase();
	var node_name;
	var filename;
	var frame_name;
	var svgObj = null;
	if ((cir_name != null) && (pwb_name == null)) {
		node_name = 'FILE1';
		filename = cir_name;
		frame_name = 'frame0';
		svgObj = parent.frame0.document.SVG1.window;
	} else if ((pwb_name != null) && (cir_name == null)) {
		node_name = 'FILE2';
		filename = pwb_name;
		frame_name = 'frame1';
		svgObj = parent.frame1.document.SVG1.window;
	}
	
	var enPartsMark = false;
	var enDataSheet = false;
	var flgDataSheet = 0;
	var pno = '';
	var pname = '';
	var bno = '';
	var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and ' + node_name + '="' + filename + '"]');
	if (nodelist.item(0) != null) {
		pno = new Array(nodelist.length - 1);
		pname = new Array(nodelist.length - 1);
		enDataSheet = new Array(nodelist.length - 1);
		for (var i = 0; i < nodelist.length; i++) {
			pno[i] = nodelist.item(i).selectSingleNode('PART_NO').text;
			pname[i] = nodelist.item(i).selectSingleNode('PART_NAME').text;
			if (nodelist.item(i).selectSingleNode('FILE3').text != '') {
				enDataSheet[i] = true;
				flgDataSheet ++;
			} else {
				enDataSheet[i] = false;
			}
		}
		if (flgDataSheet == 0) {
			enDataSheet = false;
		}
		bno = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
		enPartsMark = true;
	}
	if (svgObj != null) {
		svgObj.partsMenuUpdate(target, bno, pno, enDataSheet, enPartsMark);
	} else {
		svgObj.partsMenuUpdate(target, bno, pno, false, false);
	}
	
	defaultContextMemu(frame_name, filename, pno, pname);
}

/*************
**  部品マーク設定（SVGコンテキストメニューから）
**************/
function setPartsMark(target, blockno) {
	var selobj = parent.frametop.document.all.sel;
	var obj = document.createElement("option");
	if (selobj.length == 1 && selobj.value == '') {
		selobj[0].style.color = "black";
		selobj[0].value = "clear";
		selobj[0].text = "Clear Mark";
	}
	obj.value = blockno + "|" + target;
	obj.text = blockno + "-" + target;
	selobj.add(obj);
	selobj.selectedIndex = -1;
}

/*************
**  お気に入りリンク表示（SVGコンテキストメニューから）
**************/
function showFavoriteWindow(num, target, targetSub, cir_name, pwb_name) {
	// num : お気に入りメニュー番号
	target = target.toUpperCase();
	
	var node_name;
	var filename;
	if ((cir_name != null) && (pwb_name == null)) {
		node_name = 'FILE1';
		filename = cir_name;
	} else if ((pwb_name != null) && (cir_name == null)) {
		node_name = 'FILE2';
		filename = pwb_name;
	}
	
	var CurRefNo = "";
	var CurPartNo = "";
	var CurPartName = "";
	var CurBlockNo = "";
	
	// ラスターイメージ図面対応
	if (target == '') {
		target = selected;
	}
	
	var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and ' + node_name + '="' + filename + '"]');
	
	if (nodelist.item(0) != null) {
		CurRefNo = nodelist.item(0).selectSingleNode('SYMBOL').text;
		CurPartNo = nodelist.item(0).selectSingleNode('PART_NO').text;
		CurPartName = nodelist.item(0).selectSingleNode('PART_NAME').text;
		CurBlockNo = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
	}
	
	// クッキー読み出し
	var cookieObj = parent.parent.setup;
	var CurUserName = cookieObj.getCookie(cookieObj.cookie_UserName);
	var CurUserEmail = cookieObj.getCookie(cookieObj.cookie_UserEmail);
	
	var Favorite = new Array();
	cookieObj.readCookieFavorite(Favorite, num);
	var strName = Favorite[cookieObj.cookie_FavoriteName];
	var strUrl = Favorite[cookieObj.cookie_FavoriteUrl];
	var strSubmit = Favorite[cookieObj.cookie_FavoriteSubmit];
	var strMethod = Favorite[cookieObj.cookie_FavoriteMethod];
	var strId = Favorite[cookieObj.cookie_FavoriteId];
	var strPsswrd = Favorite[cookieObj.cookie_FavoritePsswrd];
	
	if ((strId != "") && (strPsswrd != "")) {
		var sUrl = strUrl.split("//");
		strUrl = sUrl[0] + "//" + strId + ":" + strPsswrd + "@" + sUrl[1];
	}
	
	// 擬似エントリーフォーム生成
	if (favoriteWin != null) {
		favoriteWin.close();
	}
	favoriteWin = window.open("", "Favorite");
	favoriteWin.document.writeln("<html>");
	favoriteWin.document.writeln("<head>");
	favoriteWin.document.writeln("<style>");
	favoriteWin.document.writeln("body {background-color:#FFFFFF; margin:10px; font-family:Arial,Helvetica; font-size:9pt;}");
	favoriteWin.document.writeln("#ttl {font-family:Arial,Helvetica; font-weight:bold;}");
	favoriteWin.document.writeln("input {font-family:Arial, Helvetica; font-size:9pt;}");
	favoriteWin.document.writeln("</style>");
	favoriteWin.document.writeln("</head>");
	favoriteWin.document.writeln("<body style='visibility:hidden' onload='document.body.style.visibility=\"visible\"'>");
	favoriteWin.document.writeln("<div id='ttl'>" + strName + "</div>");
	
	favoriteWin.document.writeln("<form name='baseFrom' action='" + strUrl + "' method='" + strMethod +"'>");
	
	// 送信情報差し替え
	if (strSubmit != '') {
		var submitArray = strSubmit.split('&');
		for (var i = 0; i < submitArray.length; i++) {
			var inputStr = submitArray[i].split('=');
			if (targetSub != '' ) {
				inputStr[1] = inputStr[1].replace('$(CurModel)', targetSub);
			} else {
				inputStr[1] = inputStr[1].replace('$(CurModel)', CurTargetModel);
			}
			inputStr[1] = inputStr[1].replace('$(CurManualNo)', CurManualNo);
			inputStr[1] = inputStr[1].replace('$(CurRefNo)', CurRefNo);
			if (targetSub != '' ) {
				inputStr[1] = inputStr[1].replace('$(CurPartNo)', targetSub);
			} else {
				inputStr[1] = inputStr[1].replace('$(CurPartNo)', CurPartNo);
			}
			if (targetSub != '' ) {
				inputStr[1] = inputStr[1].replace('$(CurPartName)', targetSub);
			} else {
				inputStr[1] = inputStr[1].replace('$(CurPartName)', CurPartName);
			}
			inputStr[1] = inputStr[1].replace('$(CurBlockNo)', CurBlockNo);
			inputStr[1] = inputStr[1].replace('$(CurUserName)', CurUserName);
			inputStr[1] = inputStr[1].replace('$(CurUserEmail)', CurUserEmail);
			
			favoriteWin.document.write(inputStr[0] + " = ");
			favoriteWin.document.writeln("<input type='text' name='" + inputStr[0] + "' value='" + inputStr[1] + "'>");
			favoriteWin.document.writeln("<br>");
		}
	}
	favoriteWin.document.writeln("<p><input type='submit' value='Submit'>");
	favoriteWin.document.writeln("</form>");
	favoriteWin.document.writeln("</body>");
	favoriteWin.document.writeln("</html>");
	favoriteWin.document.baseFrom.submit();
	favoriteWin.document.close();
	
}

/*************
**  マイノート、お気に入りメニュー設定（SVGコンテキストメニュー）
**************/
function defaultContextMemu(frame_name, drawid, pno, pname) {
	if (parent.parent.setup != null) {
		// クッキー読み出し
		var cookieObj = parent.parent.setup;
		// マイノートメニュー
		var MyNoteFolder = cookieObj.getCookie(cookieObj.cookie_MyNoteFolder);
		// お気に入りメニュー
		var FavoriteLength = cookieObj.getCookie(cookieObj.cookie_FavoriteLength);
		// お気に入りメニュー（送信データ）
		var FavoriteSubmit = cookieObj.getCookie(cookieObj.cookie_FavoriteSubmit);
		
		var Favorite = new Array();
		var FavoriteName = new Array();
		var FavoriteSubName = new Array();
		if (pno == '' || pname == '') {
			if (selected != '') {
				if (frame_name == 'frame0') {
					var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + selected + '" and FILE1="' + drawid + '"]');
				} else if (frame_name == 'frame1') {
					var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + selected + '" and FILE2="' + drawid + '"]');
				}
				if (nodelist.item(0) != null) {
					pno = new Array(nodelist.length - 1);
					pname = new Array(nodelist.length - 1);
					for (var i = 0; i < nodelist.length; i++) {
						pno[i] = nodelist.item(i).selectSingleNode('PART_NO').text;
						pname[i] = nodelist.item(i).selectSingleNode('PART_NAME').text;
					}
				}
			}
		}
		for (var i = 0; i <= FavoriteLength; i++) {
			if (cookieObj.readCookieFavorite(Favorite, i) == true) {
				FavoriteName[i] = Favorite[cookieObj.cookie_FavoriteName];
				if (Favorite[cookieObj.cookie_FavoriteSubmit].indexOf('$(CurModel)') != -1) {
					if (CurModel.length > 1) {
						FavoriteSubName[i] = new Array;
						for (var j = 0; j < CurModel.length; j++) {
							FavoriteSubName[i][j] = CurModel[j];
						}
					} else {
						FavoriteSubName[i] = CurModel;
					}
				} else if (Favorite[cookieObj.cookie_FavoriteSubmit].indexOf('$(CurPartNo)') != -1) {
					if (pno != '') {
						if (pno.length > 1) {
							FavoriteSubName[i] = new Array;
							for (var j = 0; j < pno.length; j++) {
								FavoriteSubName[i][j] = pno[j];
							}
						} else {
							FavoriteSubName[i] = '';
						}
					} else {
						FavoriteSubName[i] = '';
					}
				} else if (Favorite[cookieObj.cookie_FavoriteSubmit].indexOf('$(CurPartName)') != -1) {
					if (pname != '') {
						if (pno.length > 1) {
							FavoriteSubName[i] = new Array;
							for (var j = 0; j < pname.length; j++) {
								FavoriteSubName[i][j] = pname[j];
							}
						} else {
							FavoriteSubName[i] = '';
						}
					} else {
						FavoriteSubName[i] = '';
					}
				} else {
					FavoriteSubName[i] = '';
				}
			}
		}
		
		var svgObj = null;
		if (frame_name == 'frame0') {
			svgObj = parent.frame0.document.SVG1.window;
			svg0_loaded = true;
		}
		if (frame_name == 'frame1') {
			svgObj = parent.frame1.document.SVG1.window;
			svg1_loaded = true;
		}
		if (svgObj != null) {
			// parts.jsバージョン情報を引き渡す
			svgObj.parts_js = parts_js;
			if (MyNoteFolder != '') {
				svgObj.MyNoteMenuUpdate(true, CurModel);
			} else {
				svgObj.MyNoteMenuUpdate(false, CurModel);
			}
			svgObj.favoriteMenuUpdate(FavoriteName, FavoriteSubName);
		}
	} else {
		svg0_loaded = true;
		svg1_loaded = true;
	}
	
	if (pno != '' || pname != '') {
		return;
	}
	
	/*************
	**  マイドローデフォルトカラー読込み
	**************/
	if (setupMyDraw() == false) {
		return;
	}
	if (xmlmydraw.selectSingleNode("MYDRAW") != null) {
		var nodelist = xmlmydraw.selectNodes("//COLOR[@DRAW='" + drawid + "' and @MNLNO='" + CurManualNo + "']");
		for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
			svgObj.setDefaultColor(i.getAttribute("REFNO"), i.text);
		}
	}
}

/*************
**  部品検索
**************/
function searchParts(ref, cir_name, pwb_name) {
	if (event_count != 0) {
		event_count = 0;
		return;
	}
	
	//　図形非選択
	if (ref == null && cir_name == null && pwb_name == null) {
		if(elm != null){
			if (elm.length > 0) {
				for (var l = elm.length-1; l >= 0; l--) {
					elm[l].style.background = clrbackground;
					elm[l].style.color = clr;
				}
			} else {
				elm.style.background = clrbackground;
				elm.style.color = clr;
			}
			elm = null;
			selected = '';
		}
		// 電圧表を非選択表示
		if (parent != null) {
			if (parent.frame3 != null) {
				if (parent.frame3.document != null) {
					if (parent.frame3.document.all.tblvolt != null) {
						parent.frame3.findElement(null, null);
					}
				}
			}
		}
		if(parent != null) {
			if(parent.frame0 != null)
				if(parent.frame0.document != null)
					if(parent.frame0.document.SVG1 != null)
						if(parent.frame0.document.SVG1.window != null){
							parent.frame0.document.SVG1.window.setTimeout('select(' + ref + ', 0)', 0);}
			if(parent.frame1 != null)
				if(parent.frame1.document != null)
					if(parent.frame1.document.SVG1 != null)
						if(parent.frame1.document.SVG1.window != null){
							parent.frame1.document.SVG1.window.setTimeout('select(' + ref + ', 1)', 0);}
		}
	}
	
	var tm = 0;
	// 左側フレームSVG読み込み
	if(cir_name != null && cir_name != '') {
		cir_name_svgz = cir_name + ".svgz";
		if(parent.frame0.document.title != cir_name_svgz) {
			svg0_loaded = false;
			parent.frame0.document.open();
			parent.frame0.document.writeln('<html>');
			parent.frame0.document.writeln('<head>');
			parent.frame0.document.writeln('<style>');
			parent.frame0.document.writeln('body {background-color: #CCCCCC; margin: 0px;}');
			parent.frame0.document.writeln('</style>');
			parent.frame0.document.writeln('<title>' + cir_name_svgz + '</title>');
			parent.frame0.document.writeln('</head>');
			parent.frame0.document.writeln('<body id="svgframe">');
			parent.frame0.document.writeln('<embed src="../' + cir_name_svgz + '" name="SVG1" pluginspage="http://www.adobe.com/svg/viewer/install" style="width:expression(document.body.clientWidth); height:expression(document.body.clientHeight)" type="image/svg-xml">');
			parent.frame0.document.writeln('<noembed>To view SVG pages, you will need to download the viewer.</noembed>');
			parent.frame0.document.writeln('</body>');
			parent.frame0.document.writeln('</html>');
			parent.frame0.document.close();	
			tm = 1000;
		}
		// SVGクリア
		if (ref == null && pwb_name == null || pwb_name == '') {
			parent.frame1.document.open();
		}
	}
	// 右側フレームSVG読み込み
	if(pwb_name != null && pwb_name != '') {
		pwb_name_svgz = pwb_name + ".svgz";
		if(parent.frame1.document.title != pwb_name_svgz) {
			svg1_loaded = false;
			parent.frame1.document.open();
			parent.frame1.document.writeln('<html>');
			parent.frame1.document.writeln('<head>');
			parent.frame1.document.writeln('<style>');
			parent.frame1.document.writeln('body {background-color: #CCCCCC; margin: 0px;}');
			parent.frame1.document.writeln('</style>');
			parent.frame1.document.writeln('<title>' + pwb_name_svgz + '</title>');
			parent.frame1.document.writeln('</head>');
			parent.frame1.document.writeln('<body id="svgframe">');
			parent.frame1.document.writeln('<embed src="../' + pwb_name_svgz + '" name="SVG1" pluginspage="http://www.adobe.com/svg/viewer/install" style="width:expression(document.body.clientWidth); height:expression(document.body.clientHeight)" type="image/svg-xml">');
			parent.frame1.document.writeln('<noembed>To view SVG pages, you will need to download the viewer.</noembed>');
			parent.frame1.document.writeln('</body>');
			parent.frame1.document.writeln('</html>');
			parent.frame1.document.close();
			tm = 1000;
		}
		// SVGクリア
		if (ref == null && cir_name == null || cir_name == '') {
			parent.frame0.document.open();
		}
	}
	
	if (ref != null) {
		// 回路図の部品をクリックしたとき
		if ((cir_name != null) && (pwb_name == null)) {
			findElement(ref, cir_name, 'FILE1');
		// 基板図の部品をクリックしたとき
		} else if ((pwb_name != null) && (cir_name == null)) {
			findElement(ref, pwb_name, 'FILE2');
		// 部品表をクリックしたとき
		} else if((cir_name != '') || (pwb_name != '')) {
			findElementOnPartsListClick(ref, cir_name, pwb_name);
		// 部品表をクリックしたとき---CIR_LINKとPWB_LINKがNULLのとき 2002.0830 by a.oinoue Add
		} else if ((cir_name == null || cir_name == '') && (pwb_name == null || pwb_name == '')){
			findElementOnPartsListClick(ref, '', '');
		}
		
		// 部品選択状態設定 & センタリング
		if(parent != null) {
			setTimeout("select_parts_timer('" + ref + "','" + cir_name + "','" + pwb_name +"')", tm);
		}
	}
}

/*************
**  図面部品選択状態設定 & センタリング
**************/
function select_parts_timer(ref, cir_name, pwb_name) {
	if(parent.frame0 != null) {
		if(parent.frame0.document != null) {
			if(parent.frame0.document.SVG1 != null) {
				if(parent.frame0.document.SVG1.window != null && svg0_loaded == true) {
					parent.frame0.document.SVG1.window.setTimeout('select("' + ref + '", 0)', 0);
					// 選択フレーム側はセンタリング対象外
					if (pwb_name != 'null') {
						parent.frame0.document.SVG1.window.setTimeout('focusBBox(getPartsBBox("' + ref + '"))', 0);
					}
				}
			}
		}
	}
	if(parent.frame1 != null) {
		if(parent.frame1.document != null) {
			if(parent.frame1.document.SVG1 != null) {
				if(parent.frame1.document.SVG1.window != null && svg1_loaded == true) {
					parent.frame1.document.SVG1.window.setTimeout('select("' + ref + '", 1)', 0);
					// 選択フレーム側はセンタリング対象外
					if (cir_name != 'null') {
						parent.frame1.document.SVG1.window.setTimeout('focusBBox(getPartsBBox("' + ref + '"))', 0);
					}
				}
			}
		}
	}
}

/*************
**  部品表選択状態設定
**************/
function setLine(target, ref){
	if (elm == null) {
		if (target.length > 0) {
			elm = new Array(target.length - 1);
		}
		elm = target;
		selected = ref;
	} else {
		if (elm.length > 0) {
			for (var l = elm.length-1; l >= 0; l--) {
				elm[l].style.background = clrbackground;
				elm[l].style.color = clr;
			}
		} else {
			elm.style.background = clrbackground;
			elm.style.color = clr;
		}
		if (target.length > 0) {
			elm = new Array(target.length - 1);
		}
		elm = target;
		selected = ref;
	}
	if (elm != null) {
		if (elm.length > 0) {
			clrbackground = elm[0].style.background;
			clr = elm[0].style.color;
			for (var l = elm.length-1; l >= 0; l--) {
				elm[l].style.background = 'pink';
			}
			elm[0].scrollIntoView();
			selected = ref;
		} else {
			clrbackground = elm.style.background;
			clr = elm.style.color;
			elm.style.background = 'pink';
			elm.scrollIntoView();
			selected = ref;
		}
	} else {
		elm = null;
		selected = '';
	}
}

/*************
**  部品表内検索 & 関連図面表示（図面から）
**************/
function findElement(target, filename, node_name) {
	if(elm != null){
		if (elm.length > 0) {
			for (var l = elm.length-1; l >= 0; l--) {
				elm[l].style.background = clrbackground;
				elm[l].style.color = clr;
			}
		} else {
			elm.style.background = clrbackground;
			elm.style.color = clr;
		}
		elm = null;
		selected = '';
	}
	
	target = target.toUpperCase();
	
	if (blockdiagram_loaded == false) {
		var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and ' + node_name + '="' + filename + '"]');
	} else {
		var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '"]');
	}
	
	if (nodelist.item(0) != null) {
		var cir_name = nodelist.item(0).selectSingleNode('FILE1').text;
		var pwb_name = nodelist.item(0).selectSingleNode('FILE2').text;
		var block = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
		var orflg = nodelist.item(0).selectSingleNode('OR_FLG').text;
		setLine(document.all(block + target), target);
		// 回路図、基板図の部品をクリックしたとき
		if (blockdiagram_loaded == false) {
			if (cir_name != '') {
				if (parent.frametop.document.all.strradio[2].style.display != 'none') {
					searchParts(null, cir_name, pwb_name);
				}
				getTocTitle(cir_name);
			} else {
				getTocTitle(pwb_name);
			}
		// ブロック図の部品をクリックしたとき
		} else {
			getTocTitle(cir_name);
		}
	}
	
	// 電圧表を選択表示
	if (parent != null) {
		if (parent.frame3 != null) {
			if (parent.frame3.document != null) {
				if (parent.frame3.document.all.tblvolt != null) {
					parent.frame3.findElement(target, block);
				}
			}
		}
	}
}

/*************
**  部品表内検索 & 関連図面表示（部品表から）
**************/
function findElementOnPartsListClick(target, cir_name, pwb_name){
	// ブロック図を非選択にする
	blockdiagram_loaded = false;
	
	target = target.toUpperCase();
	
	var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and FILE1="' + cir_name + '" and FILE2="' + pwb_name + '"]');
	
	if (nodelist.item(0) != null) {
		var block = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
		var orflg = nodelist.item(0).selectSingleNode('OR_FLG').text;
		
		if ((cir_name != '') && (pwb_name != '')) {
			getTocTitle(cir_name);
			changeViewSize('50%', '50%');
			changeViewBtn('none', 'inline', 'inline', 'none');
			viewmode = 1;	// 配線図、基板図、部品表ビュー
		} else if ((cir_name != '') && (pwb_name == '')) {
			getTocTitle(cir_name);
			changeViewSize('*', '0');
			changeViewBtn('none', 'inline', 'none', 'none');
			viewmode = 2;	// 配線図、部品表ビュー
			parent.frame1.document.open();
		} else if ((cir_name == '') && (pwb_name != '')) {
			getTocTitle(pwb_name);
			changeViewSize('0', '*');
			changeViewBtn('none', 'none', 'none', 'inline');
			viewmode = 4;	// 機構図、部品表ビュー
			parent.frame0.document.open();
		}
		setLine(document.all(block + target), target);
	}
	
	// ラスターイメージ図面対応
	if (cir_name.toUpperCase() == 'UNKNOWN') {
		alert('The schematic diagram is unknown.');
	}
	if (pwb_name.toUpperCase() == 'UNKNOWN') {
		alert('The circuit board is unknown.');
	}
	
	// 電圧表を選択表示
	if (parent != null) {
		if (parent.frame3 != null) {
			if (parent.frame3.document != null) {
				if (parent.frame3.document.all.tblvolt != null) {
					parent.frame3.findElement(target, block);
				}
			}
		}
	}
}

/*************
**  関連メニュー項目名取得
**************/
function getTocTitle(id) {
	var nodelist = xml_doc.documentElement.getElementsByTagName("param");
   	for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
    	if (id == i.getAttribute("id")) {
			window.defaultStatus = i.getAttribute("value");
			break;
		}
	}
}

/*************
**  フレームセットサイズ変更
**************/
function changeViewSize(size0, size1) {
	var fsetObj = parent.document.all("fset_draw_draw");
	fsetObj.cols = size0 + ',' + size1;
}

/*************
**  表示フレームメニュー表示設定
**************/
function changeViewBtn(disp1, disp2, disp3, disp4) {
	parent.frametop.document.all.strradio[1].style.display = disp1;
	parent.frametop.document.all.strradio[2].style.display = disp2;
	parent.frametop.document.all.strradio[3].style.display = disp3;
	parent.frametop.document.all.strradio[4].style.display = disp4;
}

/*************
**  ランドマーク → 図面検索 & 表示（SVGコンテキストメニューから）
**************/
function searchDraw(file) {
	if(elm != null){
		if (elm.length > 0) {
			for (var l = elm.length-1; l >= 0; l--) {
				elm[l].style.background = clrbackground;
				elm[l].style.color = clr;
			}
		} else {
			elm.style.background = clrbackground;
			elm.style.color = clr;
		}
		elm = null;
		selected = '';
	}
	
	var nodelist = xmlparts.selectNodes('//ROW[FILE1="' + file + '" or FILE2="' + file + '"]');
	
	if (nodelist.item(0) != null) {
		var cir_name = nodelist.item(0).selectSingleNode('FILE1').text;
		var pwb_name = nodelist.item(0).selectSingleNode('FILE2').text;
//		var block = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
		searchParts(null, cir_name, pwb_name);
		if ((cir_name != '') && (pwb_name != '')) {
			getTocTitle(cir_name);
			changeViewSize('50%', '50%');
			changeViewBtn('none', 'inline', 'inline', 'none');
		} else if ((cir_name != '') && (pwb_name == '')) {
			getTocTitle(cir_name);
			changeViewSize('*', '0');
			changeViewBtn('none', 'inline', 'none', 'none');
			parent.frame1.document.open();
		} else if ((cir_name == '') && (pwb_name != '')) {
			getTocTitle(pwb_name);
			changeViewSize('0', '*');
			changeViewBtn('none', 'none', 'none', 'inline');
			parent.frame0.document.open();
		}
	// 部品表内に図面ファイル名がない場合(合冊時）の対応（toc.xml活用）2003.12.23
	} else {
		var nodelist = xml_doc.documentElement.getElementsByTagName("param");
   		for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
    		if (file == i.getAttribute("id")) {
				var jscrpt = nodelist.nextNode().getAttribute("value");
				jscrpt = jscrpt.split(":");
				setTimeout("parent.parent.tree." + jscrpt[1], 0);
				break;
			}
		}
	}
	
	// 電圧表を非選択表示
	if (parent != null) {
		if (parent.frame3 != null) {
			if (parent.frame3.document != null) {
				if (parent.frame3.document.all.tblvolt != null) {
					parent.frame3.findElement(null, null);
				}
			}
		}
	}
}

/*************
**  マイノートリスト → 図面検索 & 表示
**************/
function searchDraws(viewid, files) {
	var file = files.split("|");
	parent.parent.tree.openDraw(viewid, file[0], file[1]);
}

/*************
**  部品検索 & 図面表示（ブロックNO有り）
**************/
function globalSerachPartsRef(target, block_no) {
	target = target.toUpperCase();
	
	var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and BLOCK_NO="' + block_no + '"]');
	
	if (nodelist.item(0) != null) {
		var cir_name = nodelist.item(0).selectSingleNode('FILE1').text;
		var pwb_name = nodelist.item(0).selectSingleNode('FILE2').text;
//		var block = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
		
		// ラスターイメージ図面対応
		if (cir_name.toUpperCase() == 'UNKNOWN' || pwb_name.toUpperCase() == 'UNKNOWN') {
			setLine(document.all(block_no + target), target);
		} else {
			searchParts(target, cir_name, pwb_name);
		}
	} else {
		alert("'" + target + "' was not found in the parts list.");
		// 図形非選択
		searchParts(null, null, null);
	}
}

/*************
**  部品検索 & 検索結果リスト表示
**************/
function globalSerachParts(type, target){
	//	type
	// = ref 	: シンボルNO検索
	// = number : 部品番号検索
	// = name	: 部品名検索
	
	if (foundlist != null) {
		foundlist.close();
		foundlist = null;
	}
	findType = 	type;
	findText = target.toUpperCase();
	setTimeout('showFoundList()', 0);
}

/*************
**  部品検索結果画面表示
**************/
function showFoundList() {
	if (foundlist == null) {
		foundlist = window.open("foundlist.html","FoundWindow","scrollbars=yes,resizable=yes,menubar=no,directories=no,status=no,location=no,width=640,height=400");
	}
}

/*************
**  部品オーダーバスケット画面表示
**************/
function showOrderList() {
	if (basket == null) {
		basket = window.open("basket.html","BasketWindow","scrollbars=yes,resizable=yes,menubar=no,directories=no,status=no,location=no,width=600,height=400");
	}
}

/*************
**  オーダー部品情報取得 & オーダー画面表示（SVGコンテキストメニューから）
**************/
function showPartsOrder(target, pno, cir_name, pwb_name) {
	target = target.toUpperCase();
	var node_name;
	var filename;
	if ((cir_name != null) && (pwb_name == null)) {
		node_name = 'FILE1';
		filename = cir_name;
	} else if ((pwb_name != null) && (cir_name == null)) {
		node_name = 'FILE2';
		filename = pwb_name;
	}
	
	var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and ' + node_name + '="' + filename + '" and PART_NO="' + pno + '"]');
	
	if (nodelist.item(0) != null) {
		showOrderList();
//		safety = nodelist.item(0).selectSingleNode('SAFETY_FLG').text;
		symbol = nodelist.item(0).selectSingleNode('SYMBOL').text;
//		orflg = nodelist.item(0).selectSingleNode('OR_FLG').text;
		parts_no = nodelist.item(0).selectSingleNode('PART_NO').text;
		parts_name = nodelist.item(0).selectSingleNode('PART_NAME').text;
//		description = nodelist.item(0).selectSingleNode('DESCRIPTION').text;
//		area = nodelist.item(0).selectSingleNode('AREA').text;
//		qty = nodelist.item(0).selectSingleNode('QTY').text;
		blockno = nodelist.item(0).selectSingleNode('BLOCK_NO').text;
		if (order != null) {
		 	order.close();
		}
		order = window.open("order.html","OrderWindow","resizable=no,menubar=no,directories=no,status=no,location=no,width=420,height=260");
	}
}

/*************
**  データシート画面表示
**************/
function showDataSheet(target, pno, cir_name, pwb_name){
	target = target.toUpperCase();
	
	var node_name;
	var filename;
	if ((cir_name != null) && (pwb_name == null)) {
		node_name = 'FILE1';
		filename = cir_name;
	} else if ((pwb_name != null) && (cir_name == null)) {
		node_name = 'FILE2';
		filename = pwb_name;
	}
	
	var nodelist = xmlparts.selectNodes('//ROW[SYMBOL="' + target + '" and ' + node_name + '="' + filename + '" and PART_NO="' + pno + '"]');
	if (nodelist.item(0) != null) {
		var datasheet_link = nodelist.item(0).selectSingleNode('FILE3').text;
		if (datasheet_link != '') {
			var file = "../ic/" + datasheet_link + ".xml";
			dataSheet = window.open(file,"DataSheet","scrollbars=yes,resizable=yes,menubar=no,directories=no,status=no,location=no,width=640,height=480");
		} else {
			alert("The data sheet for this part is not available.");
		}
	}
}

/*************
**  部品オーダータイプ設定
**************/
function setupOrderType() {
	if (parent.parent.setup != null) {
		// クッキー読み出し
		var cookieObj = parent.parent.setup;
		// J-POST
		JpostEnabled = cookieObj.getCookie(cookieObj.cookie_JpostEnabled);
		if (JpostEnabled == "1") {
			JpostMail = cookieObj.getCookie(cookieObj.cookie_JpostMail);
			JpostAC = cookieObj.getCookie(cookieObj.cookie_JpostAC);
			JpostUS = cookieObj.getCookie(cookieObj.cookie_JpostUS);
			JpostPS = cookieObj.getCookie(cookieObj.cookie_JpostPS);
			JpostSP = cookieObj.getCookie(cookieObj.cookie_JpostSP);
			JpostFolder = cookieObj.getCookie(cookieObj.cookie_JpostFolder);
			orderType = "jpost";
			return
		}
		// JASPER
		JasperEnabled = cookieObj.getCookie(cookieObj.cookie_JasperEnabled);
		if (JasperEnabled == "1") {
			JasperMail = cookieObj.getCookie(cookieObj.cookie_JasperMail);
			JasperUS = cookieObj.getCookie(cookieObj.cookie_JasperUS);
			JasperPS = cookieObj.getCookie(cookieObj.cookie_JasperPS);
			orderType = "jasper";
			return
		}
	}
	orderType = "normal";
}

/*************
**  部品オーダーバスケット項目追加 & 画面表示（部品表から）
**************/
function addBasket(symbol, parts_no, parts_name, block, orderqty) {
	// 部品オーダー用XMLロード後、ROWノードを動的生成する
	
	// PARTSORDERノード取得
	var order_node = xmlorder.selectSingleNode("PARTSORDER");
	
	// ROWノードの作成
	var row_node = xmlorder.createElement("ROW");
	// ROWノードに属性[NO]を作成
	var rowno = xmlorder.createAttribute("NO");
	// 属性オブジェクト[NO]にID_NOを設定
	rowno.value = ordercnt;
	// ROWノードに属性[NO]を設定
	row_node.setAttributeNode(rowno);
//	// ROWノード数取得
//	var rownodelist = order_node.selectNodes("ROW");
	// ROWノードに属性[MODELNO]を作成
	var rownodel = xmlorder.createAttribute("MODELNO");
	// 属性オブジェクト[MODELNO]にCurTargetModelを設定
	rownodel.value = CurTargetModel;
	// ROWノードに属性[MODELNO]を設定
	row_node.setAttributeNode(rownodel);
	// PARTSORDERノードにINFOノードを追加
	order_node.appendChild(row_node);
	
	// SYMBOLノードの作成
	var symbol_node = xmlorder.createElement("SYMBOL");
	// SYMBOLノードに値をセット
	symbol_node.text = symbol;
	// ROWノードにSYMBOLノードを追加
	row_node.appendChild(symbol_node);
	
	// PART_NOノードの作成
	var partno_node = xmlorder.createElement("PART_NO");
	// PART_NOノードに値をセット
	partno_node.text = parts_no;
	// ROWノードにPART_NOノードを追加
	row_node.appendChild(partno_node);
	
	// PART_NAMEノードの作成
	var partname_node = xmlorder.createElement("PART_NAME");
	// PART_NAMEノードに値をセット
	//partname_node.text = parts_name;	
	partname_node.text = parts_name.slice(0, 15);	// 15カラムに制限
	// ROWノードにPART_NAMEノードを追加
	row_node.appendChild(partname_node);
	
	// BLOCK_NOノードの作成
	var block_node = xmlorder.createElement("BLOCK_NO");
	// BLOCK_NOノードに値をセット
	block_node.text = block;
	// ROWノードにBLOCK_NOノードを追加
	row_node.appendChild(block_node);
	
	// ORDERQTYノードの作成
	var orderqty_node = xmlorder.createElement("ORDERQTY");
	// ORDERQTYノードに値をセット
	orderqty_node.text = orderqty;
	// ROWノードにORDERQTYノードを追加
	row_node.appendChild(orderqty_node);
	
	ordercnt ++;
	
	if (basket != null) {
		basket.close();
		basket = null;
	}
	setTimeout("showOrderList()", 0);
}


/*************
**  部品オーダーバスケット指定項目の個数変更（バスケットウィンドウから）
**************/
function changeOrderQty(rowno, orderQty) {
	var order_node = xmlorder.selectSingleNode("PARTSORDER");
	var row_node = order_node.selectNodes("ROW[@NO=" + rowno + "]/ORDERQTY");
	row_node.item(0).text = orderQty;
}

/*************
**  部品オーダーバスケット指定項目削除（バスケットウィンドウから）
**************/
function deleteOrder(rowno) {
	var order_node = xmlorder.selectSingleNode("PARTSORDER");
	var row_node = order_node.selectNodes("ROW[@NO=" + rowno + "]");
	order_node.removeChild(row_node.item(0));
	
	// ROWノード数取得
	var row_nodelist = order_node.selectNodes("ROW");
	if (row_nodelist.length == 0) {
		ordercnt = 0;
	}
}

/*************
**  部品オーダーバスケット全項目削除（バスケットウィンドウから）
**************/
function resetOrder() {
	// XMLデータの再読み込み
	xmlorder.loadXML('<?xml version="1.0"?><PARTSORDER/>');
	ordercnt = 0;
}

/*************
**  部品オーダーバスケット全項目保存：XML（バスケットウィンドウから）
**************/
function saveOrderXml() {
	if (parent.parent.setup != null) {
		// クッキー読み出し
		var cookieObj = parent.parent.setup;
		// マイノートメニュー
		var MyNoteFolder = cookieObj.getCookie(cookieObj.cookie_MyNoteFolder);
	}
	var savefile = MyNoteFolder + "\\order.xml";
	
	var xmltext = xmlorder.xml;
//	xmltext = xmltext.replace('<?xml version="1.0"?>', '<?xml version="1.0" encoding="utf-8" ?>');
	xmltext = xmltext.replace('<?xml version="1.0"?>', '<?xml version="1.0" encoding="shift_jis" ?>');
	
//	var fso = new ActiveXObject("Scripting.FileSystemObject");
//	var fsoTextFile = fso.CreateTextFile(savefile, true);
//	fsoTextFile.write(xmltext);
//	fsoTextFile.close();
	var fsoTextFile = fso.FileOpen(savefile, "w");
	if (fsoTextFile == -1) {
		alert(fsoTextFile + ": cannot open.");
		return;
	}
	var ans = fso.write(xmltext, fsoTextFile);
	if (ans == -1) {
		alert("File writing error !");
	}
	fso.FileClose(fsoTextFile);
	
	alert("Complete saveing file.");
}

/*************
**  部品オーダーバスケット全項目保存：タブ区切りテキスト（バスケットウィンドウから）
**************/
function saveOrderText(fileName) {
	var tabtext = "";
	var nodelist = xmlorder.selectNodes("//PARTSORDER/ROW");
   	
   	for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
		//tabtext += i.selectSingleNode("PART_NO").text + "\t" + i.selectSingleNode("ORDERQTY").text + "\t" + i.getAttribute("MODELNO") + "\t" + i.selectSingleNode("PART_NAME").text + "\r\n";
		tabtext += i.selectSingleNode("PART_NO").text + "\t" + i.selectSingleNode("ORDERQTY").text + "\t" + CurTargetModel.slice(0, 15) + "\t" + i.selectSingleNode("PART_NAME").text + "\r\n";
	}
	
	var savefileName = JpostFolder + "\\" + fileName + ".txt";
//	var fso = new ActiveXObject("Scripting.FileSystemObject");
//	var fsoTextFile = fso.CreateTextFile(savefileName, true);
//	fsoTextFile.write(tabtext);
//	fsoTextFile.close();
	var fsoTextFile = fso.FileOpen(savefileName, "w");
	if (fsoTextFile == -1) {
		alert(fsoTextFile + ": cannot open.");
		return;
	}
	var ans = fso.write(tabtext, fsoTextFile);
	if (ans == -1) {
		alert("File writing error !");
	}
	fso.FileClose(fsoTextFile);
	
//	alert("Complete saveing file.");
}

/*************
**  マイノート編集画面表示（SVGコンテキストメニューから）
**************/
function showMyNote(drawingid, targetModel, blockno, refno) {
	setupMyNote();
	
	if (blockno == null) {
		blockno = "";
	}
	if (refno == "") {
		if (selected != '') {
			refno = selected;
		} else {
			refno = "";
		}
	}
	
	// クッキー読み出し
	var cookieObj = parent.parent.setup;
	var note_registrar = cookieObj.getCookie(cookieObj.cookie_UserName);
	var note_registrarmail = cookieObj.getCookie(cookieObj.cookie_UserEmail);
	var dt = new Date();
	y = dt.getFullYear();
	m = dt.getMonth() + 1;	if (m < 10) m = "0" + m
	d = dt.getDate();		if (d < 10) d = "0" + d;
	var note_regdate = y + "/" + m + "/" + d;
	
	// MYNOTEノード取得
	var mynote_node = xmlmynote.selectSingleNode("MYNOTE");
	// 改行
	var cr = xmlmynote.createTextNode("\n");
	mynote_node.appendChild(cr);
	
	// INFOノードの作成
	var info_node = xmlmynote.createElement("INFO");
	
	// INFOノードに属性[MNLNO]を作成
	var mnlno = xmlmynote.createAttribute("MNLNO");
	mnlno.value = CurManualNo;
	info_node.setAttributeNode(mnlno);
	
	// INFOノードに属性[TITLE]を作成
	var title = xmlmynote.createAttribute("TITLE");
	title.value = '';
	info_node.setAttributeNode(title);
	
	// INFOノードに属性[DRAW]を作成
	var drawno = xmlmynote.createAttribute("DRAW");
	drawno.value = drawingid;
	info_node.setAttributeNode(drawno);
	
	// INFOノードに属性[VIEW]を作成
	var viewno = xmlmynote.createAttribute("VIEW");
	viewno.value = viewmode;
	info_node.setAttributeNode(viewno);
	
	// INFOノードに属性[DRAWS]を作成
	var drawnos = xmlmynote.createAttribute("DRAWS");
	var svg_name1 = parent.frame0.document.title.substring(0, parent.frame0.document.title.lastIndexOf('.'));
	var svg_name2 = parent.frame1.document.title.substring(0, parent.frame1.document.title.lastIndexOf('.'));
	drawnos.value = svg_name1 + "|" + svg_name2;
	info_node.setAttributeNode(drawnos);
	
	// INFOノードに属性[DATE]を作成
	var regdate = xmlmynote.createAttribute("DATE");
	regdate.value = note_regdate;
	info_node.setAttributeNode(regdate);
	
	// INFOノードに属性[ID]を作成
	var idno = xmlmynote.createAttribute("ID");
	idno.value = "0";
	info_node.setAttributeNode(idno);
	
	// MYNOTEノードにINFOノードを追加
	mynote_node.appendChild(info_node);
	// 改行
//	var cr = xmlmynote.createTextNode("\n");
	
	// MODELノードの作成
	var modelname_node = xmlmynote.createElement("MODEL");
	modelname_node.text = targetModel;
	
	// MODELノードに属性[BLOCKNO]を作成
	var blkno = xmlmynote.createAttribute("BLOCKNO");
	blkno.value = blockno;
	modelname_node.setAttributeNode(blkno);
	
	// MODELノードに属性[REFNO]を作成
	var ref = xmlmynote.createAttribute("REFNO");
	ref.value = refno;
	modelname_node.setAttributeNode(ref);
	
	// INFOノードにMODELノードを追加
	info_node.appendChild(modelname_node);
	
	// NOTEノードの作成
	var note_node = xmlmynote.createElement("NOTE");
	// NOTEノードに値をセット
	note_node.text = '';
	
	// NOTEノードに属性[CLASSID]を作成
	var classvalue = xmlmynote.createAttribute("CLASSID");
	classvalue.value = 'Note';
	note_node.setAttributeNode(classvalue);
	
	// NOTEノードに属性[CLASS]を作成
	var noteclass = xmlmynote.createAttribute("CLASS");
	noteclass.value = 'Note';
	note_node.setAttributeNode(noteclass);
	
	// INFOノードにNOTEノードを追加
	info_node.appendChild(note_node);
	
	// REGISTRARノードの作成
	var registrar_node = xmlmynote.createElement("REGISTRAR");
	registrar_node.text = note_registrar;
	
	// REGISTRARノードに属性[EMAIL]を作成
	var registrarmail = xmlmynote.createAttribute("EMAIL");
	registrarmail.value = note_registrarmail;
	registrar_node.setAttributeNode(registrarmail);
	
	// INFOノードにREGISTRARノードを追加
	info_node.appendChild(registrar_node);
	
	// ATTACHノードの作成
	var attach_node = xmlmynote.createElement("ATTACH");
	attach_node.text = ''
	info_node.appendChild(attach_node);
	
	// LINKノードの作成
	var link_node = xmlmynote.createElement("LINK");
	link_node.text = '';
	info_node.appendChild(link_node);
	
	// マイノート編集画面表示
	viewMyNote(0, "true"); 
}

/*************
**  マイノート1件削除（マイノート一覧表示画面から）
**************/
function deleteMyNote(id) {
	var mynote_node = xmlmynote.selectSingleNode("MYNOTE");
	var nodelist = mynote_node.selectNodes("*");
    for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
		if (id == i.getAttribute("ID")) {
			mynote_node.removeChild(i);
		}
		//  属性[ID]を全て削除
		i.removeAttribute("ID");
    }
	
	// XML保存
	saveXml(xmlmynote.xml);
}

/*************
**  マイノート保存
**************/
function saveXml(xmltext) {
	xmltext = xmltext.replace('<?xml version="1.0"?>', '<?xml version="1.0" encoding="shift_jis" ?>');
	var fsoTextFile = fso.FileOpen(note_savefile, "w");
	if (fsoTextFile == -1) {
		alert(fsoTextFile + ": cannot open.");
		return;
	}
	var ans = fso.write(xmltext, fsoTextFile);
	if (ans == -1) {
		alert("File writing error !");
	}
	fso.FileClose(fsoTextFile);
}

/*************
**  マイノート画面表示（マイノート一覧表示画面、またはマイノート表示画面から）
**************/
function viewMyNote(id, editEnable) {
	var variableNode = xslmynote.getElementsByTagName("xsl:variable[@name='edit']");
	variableNode.item(0).text = editEnable;
	var variableNode = xslmynote.getElementsByTagName("xsl:variable[@name='id']");
	variableNode.item(0).text = id;
	
	if (mynote != null) {
		mynote.close();
	}
	mynote = window.open("mynote.html", "MyNote","scrollbars=yes,resizable=yes,menubar=no,directories=no,status=no,location=no,width=580,height=530");
}

/*************
**  マイノート一覧画面表示（SVGコンテキストメニューから）
**************/
function showMyNoteList(drawnum) {
	setupMyNote();
	setAttributeIdNode();
	
	var variableNode = xslmynotelist.getElementsByTagName("xsl:variable[@name='drawno']");
	variableNode.item(0).text = drawnum;
	
	if (mynotelist != null) {
		mynotelist.close();
	}
	mynotelist = window.open("mynotelist.html", "MyNoteList","scrollbars=yes,resizable=yes,menubar=no,directories=no,status=no,location=no,width=640,height=530");
}

/*************
**  マイノート一覧画面表示用ID属性設定
**************/
function setAttributeIdNode() {
	// INFOノード属性[ID]を動的生成し、識別連番を自動採番する
	// MYNOTEノード取得
	var mynote_node = xmlmynote.selectSingleNode("MYNOTE");
	// MYNOTEノード直下のノードリスト（INFOノード）取得
	var nodelist = mynote_node.selectNodes("*");
    // INFOノード直下の全てのノードに対するループ
    var no = 1;
    for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
		//  属性オブジェクト[ID]の作成
    	var id = xmlmynote.createAttribute("ID");
		id.value = no;
		i.setAttributeNode(id);
        no ++;
    }
}
/*************
**  マイノートID属性設定解除
**************/
function resetAttributeIdNode() {
	// 動的に生成されたINFOノード属性[ID]を全て削除する
	// MYNOTEノード取得
	var mynote_node = xmlmynote.selectSingleNode("MYNOTE");
	// MYNOTEノード直下のノードリスト（INFOノード）取得
	var nodelist = mynote_node.selectNodes("*");
    // INFOノード直下の全てのノードに対するループ
    for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
		i.removeAttribute("ID");
    }
}

/*************
**  マイメモフォルダー、図面ID設定
**************/
function setupMyNote() {
	if (parent.parent.setup != null) {
		// クッキー読み出し
		var cookieObj = parent.parent.setup;
		// マイノートメニュー
		var MyNoteFolder = cookieObj.getCookie(cookieObj.cookie_MyNoteFolder);
	}
	note_savefile = MyNoteFolder + "\\" + CurManualNo + "_mn001.xml";
	xmlmynote.load(note_savefile);
	
	// 既存ファイルが存在しない場合は、新規XMLを生成
	if (xmlmynote.selectSingleNode("MYNOTE") == null) {
		xmlmynote.loadXML('<?xml version="1.0"?><MYNOTE/>');
	}
}

/*************
**  マイドロー設定（SVGコンテキストメニュー"色変更"から）
**************/
function saveMyDraw(drawingid, refno, color) {
	if (setupMyDraw() == false) {
		return;
	}
	if (refno == null) {
		refno = "";
	}
	
	// 既存の場合は一旦削除
	var mydraw_node = xmlmydraw.selectSingleNode("MYDRAW");
	if (mydraw_node != null) {
		var nodelist = xmlmydraw.selectNodes("//COLOR[@DRAW='" + drawingid + "' and @REFNO='" + refno + "' and @MNLNO='" + CurManualNo + "']");
		for (var i = nodelist.nextNode(); i != null; i = nodelist.nextNode()) {
			mydraw_node.removeChild(i);
		}
	}
	
	// MYDRAWノード取得
	var mydraw_node = xmlmydraw.selectSingleNode("MYDRAW");
	// 改行
	var cr = xmlmydraw.createTextNode("\n");
	mydraw_node.appendChild(cr);
	
	// COLORノードの作成
	var color_node = xmlmydraw.createElement("COLOR");
	color_node.text = color;
	
	// COLORノードに属性[MNLNO]を作成
	var mnlno = xmlmydraw.createAttribute("MNLNO");
	mnlno.value = CurManualNo;
	color_node.setAttributeNode(mnlno);
	
	// COLORノードに属性[DRAW]を作成
	var drawno = xmlmydraw.createAttribute("DRAW");
	drawno.value = drawingid;
	color_node.setAttributeNode(drawno);
	
	// COLORノードに属性[REFNO]を作成
	var ref = xmlmydraw.createAttribute("REFNO");
	ref.value = refno;
	color_node.setAttributeNode(ref);
	
	// MYDRAWノードにCOLORノードを追加
	if (color != '#000000') {
		mydraw_node.appendChild(color_node);
	}
	
	xmltext = xmlmydraw.xml;
	xmltext = xmltext.replace('<?xml version="1.0"?>', '<?xml version="1.0" encoding="shift_jis" ?>');
	var fsoTextFile = fso.FileOpen(draw_savefile, "w");
	if (fsoTextFile == -1) {
		alert(fsoTextFile + ": cannot open.");
		return;
	}
	var ans = fso.write(xmltext, fsoTextFile);
	if (ans == -1) {
		alert("File writing error !");
	}
	fso.FileClose(fsoTextFile);
}

/*************
**  マイドロー、図面ID設定
**************/
function setupMyDraw() {
	var MyNoteFolder = '';
	if (parent.parent.setup != null) {
		// クッキー読み出し
		var cookieObj = parent.parent.setup;
		// マイノートメニュー
		 MyNoteFolder = cookieObj.getCookie(cookieObj.cookie_MyNoteFolder);
	}
	if (MyNoteFolder == '') {
		return false;
	}
	draw_savefile = MyNoteFolder + "\\" + CurManualNo + "_md001.xml";
	xmlmydraw.load(draw_savefile);
	
	// 既存ファイルが存在しない場合は、新規XMLを生成
	if (xmlmydraw.selectSingleNode("MYDRAW") == null) {
		xmlmydraw.loadXML('<?xml version="1.0"?><MYDRAW/>');
	}
	return true;
}

/*************
**  部品表更新ファイル設定
**************/
function setupPartsDiff() {
	if (parent.parent.setup != null) {
		// クッキー読み出し
		var cookieObj = parent.parent.setup;
		// マイノートメニュー
		var UpdateFolder = cookieObj.getCookie(cookieObj.cookie_UpdateFolder);
	}
	var partsdiff_savefile = UpdateFolder + "\\" + CurManualNo + "_dl001.xml";
	xmlparts_diff.load(partsdiff_savefile);
	
	// 既存ファイルが存在しない場合は、新規XMLを生成
	if (xmlparts_diff.selectSingleNode("PARTSLIST") == null) {
		xmlparts_diff.loadXML('<?xml version="1.0"?><PARTSLIST/>');
	}
}

/*************
**  図面色変更用ダイアログ表示（SVGコンテキストメニューから）
**************/
function colorDialog(defaultColor, frame_name) {
	// IE6 以上
	col = Dialog.ChooseColorDlg(defaultColor);				// カラーダイアログを表示する
	col = "00000" + col.toString(16);						// 16進数に変換
	col = "#" + col.substring(col.length - 6, col.length);	// 右端から6桁のみ取得
	
	var svgObj = null;
	if (frame_name == 'frame0') {
		svgObj = parent.frame0.document.SVG1.window;
	}
	if (frame_name == 'frame1') {
		svgObj = parent.frame1.document.SVG1.window;
	}
	svgObj.changeColor(col);
}
